/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.property;

import net.ilexiconn.llibrary.server.property.IFloatProperty;

public interface IFloatRangeProperty
extends IFloatProperty {
    @Override
    default public boolean isValidFloat(float value) {
        return value >= this.getMinFloatValue() && value <= this.getMaxFloatValue();
    }

    public float getMinFloatValue();

    public float getMaxFloatValue();

    default public float getFloatValueRange() {
        return this.getMaxFloatValue() - this.getMinFloatValue();
    }

    public static class WithState
    extends IFloatProperty.WithState
    implements IFloatRangeProperty {
        private final float minFloatValue;
        private final float maxFloatValue;

        public WithState(float value, float minFloatValue, float maxFloatValue) {
            super(value);
            this.minFloatValue = minFloatValue;
            this.maxFloatValue = maxFloatValue;
        }

        @Override
        public float getMinFloatValue() {
            return this.minFloatValue;
        }

        @Override
        public float getMaxFloatValue() {
            return this.maxFloatValue;
        }
    }
}

